package jamezo97.clonecraft;

import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.network.Handler10KillClone;
import jamezo97.clonecraft.render.RenderCustom;

import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet3Chat;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import cpw.mods.fml.common.network.IChatListener;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ChatListener implements IChatListener {

	@Override
	public Packet3Chat serverChat(NetHandler handler, Packet3Chat message) {
		if(CloneCraft.isDebugMode()){
			if(message.message.equalsIgnoreCase("hungary")){
				List l = handler.getPlayer().worldObj.getEntitiesWithinAABB(EntityClone.class, handler.getPlayer().boundingBox.expand(5, 5, 5));
				if(l.size() > 0){
					EntityClone clone = (EntityClone)l.get(0);
					clone.foodStats.setFoodLevel(10);
					handler.getPlayer().getFoodStats().setFoodLevel(10);
					handler.getPlayer().sendChatToPlayer(ChatMessageComponent.createFromText("Woohoo. " + clone.getName()));
				}
			}else if(message.message.equalsIgnoreCase("strike")){
				MovingObjectPosition mop = rayTrace(handler.getPlayer(), 100, 0);
				if(mop != null){
					World world = handler.getPlayer().worldObj;
					int topY = world.getTopSolidOrLiquidBlock(mop.blockX, mop.blockZ);
					EntityLightningBolt lighting = new EntityLightningBolt(world, mop.blockX, topY, mop.blockZ);
					world.addWeatherEffect(lighting);
					if(world.getBlockId(mop.blockX, topY-1, mop.blockZ) == CloneCraft.antenna.blockID){
						CloneCraft.antenna.chargeAntenna(mop.blockX, topY-1, mop.blockZ, world);
					}
				}
			}else if(message.message.equalsIgnoreCase("killdemall")){
				List l = handler.getPlayer().worldObj.getEntitiesWithinAABB(EntityClone.class, handler.getPlayer().boundingBox.expand(50, 50, 50));
				
				for(int a = 0; a < l.size(); a++){
					EntityClone clone = (EntityClone)l.get(a);
					clone.commitSuicide();
					Handler10KillClone handler1 = new Handler10KillClone(clone.entityId);
					handler1.sendToAllWatching(clone);
				}
			}else if(message.message.toLowerCase().startsWith("polygon")){
				String[] split = message.message.split(" ");
				if(split.length == 3){
					String sPoints = split[1];
					String sSize = split[2];
					boolean success = false;
					int points = 0;
					int size = 0;
					try{
						points = Integer.parseInt(sPoints);
						size = Integer.parseInt(sSize);
						success = true;
					}catch(Exception e){
						e.printStackTrace();
					}
					if(success){
						EntityPlayer player = handler.getPlayer();
						int y = (int) Math.floor(player.posY)-1;
						double centreX = Math.floor(player.posX)+.5;
						double centreZ = Math.floor(player.posZ)+.5;
						World world = player.worldObj;
						for(int a = 0; a < points; a++){
							double done = ((double)a) / ((double)points);
							double rad = Math.PI * 2 * done;
							int x = (int)Math.floor(Math.sin(rad) * size + centreX);
							int z = (int)Math.floor(Math.cos(rad) * size + centreZ);
							world.setBlock(x, y, z, Block.cloth.blockID, /*a%15*/colour, 2);
						}
						colour++;
						if(colour > 15){
							colour = 0;
						}
					}
				}
				
			}else if(message.message.toLowerCase().startsWith("sphere")){
				String[] parts = message.message.split(" ");
				if(parts.length == 2){
					String sRadius = parts[1];
					int radiusWholeCircle = 0;
					boolean success = true;
					try{
						radiusWholeCircle = Integer.parseInt(parts[1]);
					}catch(Exception e){
						e.printStackTrace();
						success = false;
					}
					if(success){
						int diameter = radiusWholeCircle * 2;
						EntityPlayer player = handler.getPlayer();
						int minY = (int)Math.floor(player.posY)-radiusWholeCircle;
						double centreX = Math.floor(player.posX)+.5;
						double centreZ = Math.floor(player.posZ)+.5;
						World world = player.worldObj;
						
						for(int a = 0; a < diameter; a++){
							double done1 = (double)a / (double)(diameter-1);
							double radPerc = Math.sin(done1*Math.PI);
							int radius = (int)Math.round(radPerc * radiusWholeCircle);
							int points = radius * 25 + 5;
							for(int b = 0; b < points; b++){
								double done = ((double)b) / ((double)points);
								double rad = Math.PI * 2 * done;
								int x = (int)Math.floor(Math.sin(rad) * radius + centreX);
								int z = (int)Math.floor(Math.cos(rad) * radius + centreZ);
								world.setBlock(x, minY + a, z, Block.cloth.blockID, colour, 2);
							}
							colour++;
							if(colour > 15){
								colour = 0;
							}
						}
					}
				}
				//cylinder radius height [block id] [block meta]
			}else if(message.message.toLowerCase().startsWith("cylinder")){
				String[] parts = message.message.split(" ");
				if(parts.length > 2 && parts.length < 6){
					int radius = 0;
					int height = 0;
					int blockId = -1;
					int blockMeta = 0;
					boolean success = true;
					try{
						radius = Integer.parseInt(parts[1]);
						height = Integer.parseInt(parts[2]);
						if(parts.length > 3){
							blockId = Integer.parseInt(parts[3]);
						}
						if(parts.length > 4){
							blockMeta = Integer.parseInt(parts[4]);
						}
					}catch(Exception e){
						e.printStackTrace();
						success = false;
					}
					if(success){
						EntityPlayer player = handler.getPlayer();
						int minY = (int)Math.floor(player.posY);
						double centreX = Math.floor(player.posX)+.5;
						double centreZ = Math.floor(player.posZ)+.5;
						World world = player.worldObj;
						
						for(int a = 0; a < height; a++){
							int points = radius * 20 + 5;
							for(int b = 0; b < points; b++){
								double done = ((double)b) / ((double)points);
								double rad = Math.PI * 2 * done;
								int x = (int)Math.floor(Math.sin(rad) * radius + centreX);
								int z = (int)Math.floor(Math.cos(rad) * radius + centreZ);
								world.setBlock(x, minY + a, z, blockId > -1?blockId:Block.cloth.blockID, blockId>-1?blockMeta:colour, 2);
							}
							
						}
						if(blockId<0){
							colour++;
							if(colour > 15){
								colour = 0;
							}
						}
					}
				}
			}else if(message.message.equalsIgnoreCase("retard")){
				final EntityPlayer player = handler.getPlayer();
				final double startX = player.posX;
				final double startY = player.posY;
				final double startZ = player.posZ;
				new Thread(){
					public void run(){
						int maxShifts = 20;
						int shifts = maxShifts;
						int minShiftLength = 200;
						int maxShiftLength = 900;
						int shiftlengthBetween = maxShiftLength = minShiftLength;
						Random rand = new Random();
						while(shifts-- > 0){
							double done = ((double)maxShifts - shifts) / ((double)maxShifts);
							int shiftLength = rand.nextInt(shiftlengthBetween) + minShiftLength;
							long finishTime = System.currentTimeMillis() + shiftLength;
							double posX = startX + rand.nextDouble()/2 - .5;
							double posY = startY + rand.nextDouble()/2 - .5;
							double posZ = startZ + rand.nextDouble()/2 - .5;
							while(System.currentTimeMillis() < finishTime){
								if(Minecraft.getMinecraft().thePlayer != null){
									EntityPlayer p1 = Minecraft.getMinecraft().thePlayer;
									p1.setPosition(posX + rand.nextDouble()/10 - .05, posY + rand.nextDouble()/10 - .05, posZ + rand.nextDouble()/10 - .05);
									p1.rotationPitch += rand.nextFloat()*20*done - 10*done;
									p1.rotationYaw += rand.nextFloat()*20*done - 10*done;
								}
								try{
									Thread.sleep(50);
								}catch(Exception e){
									e.printStackTrace();
								}
							}
							
							
						}
						
					}
				}.start();
			}else if(message.message.toLowerCase().startsWith("killall")){
				String[] split = message.message.split(" ");
				String eName = null;
				if(split.length > 1){
					eName = split[1];
				}
				
				World world = handler.getPlayer().worldObj;
				if(eName == null){
					for(int a = 0; a < world.loadedEntityList.size(); a++){
						if(!(world.loadedEntityList.get(a) instanceof EntityPlayer)){
							world.removeEntity((Entity)world.loadedEntityList.get(a));
						}
					}
				}else{
					for(int a = 0; a < world.loadedEntityList.size(); a++){
						Entity e = (Entity)world.loadedEntityList.get(a);
						if(e.getEntityName().equals(eName) && !(e instanceof EntityPlayer)){
							world.removeEntity((Entity)world.loadedEntityList.get(a));
						}
					}
				}
				
			}else if(message.message.toLowerCase().startsWith("setscale")){
				String[] split = message.message.split(" ");
				if(split.length == 2){
					try{
						RenderCustom.scale = Float.parseFloat(split[1]);
					}catch(Exception e){
						e.printStackTrace();
					}
					
				}
			}else if(message.message.toLowerCase().equals("myid")){
				handler.getPlayer().sendChatToPlayer(ChatMessageComponent.createFromText("Your ID: " + handler.getPlayer().entityId));
			}/*else if(message.message.toLowerCase().startsWith("test")){
			}
				EntityPlayer player = handler.getPlayer();
				int pposX = (int)Math.round(player.posX);
				int pposY = (int)Math.round(player.posY);
				int pposZ = (int)Math.round(player.posZ);
				int posY = 256;
				for(; posY >= 0; posY--){
					if(player.worldObj.getBlockId(pposX, posY, pposZ) != 0){
						posY++;
						break;
					}
				}
				int chunkX = (pposX >> 4) * 16;
				int chunkZ = (pposZ >> 4) * 16;
				for(int x = 0; x < 16; x++){
					for(int z = 0; z < 16; z++){
						EntityClone clone = new EntityClone(player.worldObj);
						clone.setPosition(chunkX + x, posY, chunkZ + z);
						player.worldObj.spawnEntityInWorld(clone);
					}
				}
			}else if(message.message.toLowerCase().startsWith("setscale")){
				String[] parts = message.message.split(" ");
				if(parts.length == 2){
					try{
						double d = Double.parseDouble(parts[1]);
						RendererLivingEntity.scale = d;
					}catch(Exception e){
						e.printStackTrace();
					}
				}
				double midX = (((int)Math.floor(par1EntityLivingBase.posX)) >> 4) * 16.0 + 8;
        double midZ = (((int)Math.floor(par1EntityLivingBase.posZ)) >> 4) * 16.0 + 8;
        
        double x = (par1EntityLivingBase.posX - midX) * (par1EntityLivingBase.posX - midX);
        double z = (par1EntityLivingBase.posZ - midZ) * (par1EntityLivingBase.posZ - midZ);
        double d = (Math.sqrt(x + z));
        double d5 = d/scale;// / 50;
        GL11.glScaled(1 + d5, 1 + d5, 1 + d5);
			}*/
		}
		return message;
	}

	
	int colour = 0;

	@Override
	public Packet3Chat clientChat(NetHandler handler, Packet3Chat message) {
		return message;
	}
	
    /**
     * interpolated position vector
     */
    public Vec3 getPosition(EntityLivingBase e, float par1)
    {
        if (par1 == 1.0F)
        {
            return e.worldObj.getWorldVec3Pool().getVecFromPool(e.posX, e.posY, e.posZ);
        }
        else
        {
            double d0 = e.prevPosX + (e.posX - e.prevPosX) * (double)par1;
            double d1 = e.prevPosY + (e.posY - e.prevPosY) * (double)par1;
            double d2 = e.prevPosZ + (e.posZ - e.prevPosZ) * (double)par1;
            return e.worldObj.getWorldVec3Pool().getVecFromPool(d0, d1, d2);
        }
    }

    /**
     * Performs a ray trace for the distance specified and using the partial tick time. Args: distance, partialTickTime
     */
    public MovingObjectPosition rayTrace(EntityLivingBase e, double par1, float par3)
    {
        Vec3 vec3 = getPosition(e, par3);
        Vec3 vec31 = e.getLook(par3);
        Vec3 vec32 = vec3.addVector(vec31.xCoord * par1, vec31.yCoord * par1, vec31.zCoord * par1);
        return e.worldObj.clip(vec3, vec32);
    }

}
